package com.bytesbee.mysinglelivechannel.activities;

import static com.bytesbee.mysinglelivechannel.utils.Constant.FALSE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TRUE;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.api.ApiInterface;
import com.bytesbee.mysinglelivechannel.api.RestAdapter;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackUser;
import com.bytesbee.mysinglelivechannel.managers.DialogManager;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.Constant;
import com.bytesbee.mysinglelivechannel.utils.Utils;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public class ChangePasswordActivity extends BaseAppActivity {

    private ChangePasswordActivity mActivity;
    private Call<CallbackUser> callbackCall = null;
    private EditText txtConfirmPassword, txtNewPassword, txtOldPassword;
    private String strEmail, strUsername, strConfirmPassword, strNewPassword, strOldPassword;

    /**
     * Initialize the UI layout
     */
    @SuppressLint("SetTextI18n")
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_change_password);
        setImmersionBarTheme();
        mActivity = this;

        txtOldPassword = findViewById(R.id.txtOldPassword);
        txtNewPassword = findViewById(R.id.txtNewPassword);
        txtConfirmPassword = findViewById(R.id.txtConfirmPassword);
        strUsername = SessionManager.get().getUserModel().getUsername();
        strEmail = SessionManager.get().getUserModel().getEmail();
        final TextView lblEmail = findViewById(R.id.lblEmail);
        final TextView lblUsername = findViewById(R.id.lblUsername);

        lblEmail.setText(SessionManager.get().getUserModel().getEmail());
        lblUsername.setText("@" + SessionManager.get().getUserModel().getUsername());

        final TextView btnUpdate = findViewById(R.id.btnUpdate);
        btnUpdate.setOnClickListener(view -> {
            try {
                strOldPassword = txtOldPassword.getText().toString().trim();
                strNewPassword = txtNewPassword.getText().toString().trim();
                strConfirmPassword = txtConfirmPassword.getText().toString().trim();
                if (TextUtils.isEmpty(strOldPassword)) {
                    DialogManager.checkEmptyFields(getString(R.string.err_old_password), txtOldPassword);
                    return;
                } else if (TextUtils.isEmpty(strNewPassword)) {
                    DialogManager.checkEmptyFields(getString(R.string.err_new_password), txtNewPassword);
                    return;
                } else if (TextUtils.isEmpty(strConfirmPassword)) {
                    DialogManager.checkEmptyFields(getString(R.string.err_confirm_password), txtConfirmPassword);
                    return;
                } else if (!strNewPassword.equalsIgnoreCase(strConfirmPassword)) {
                    DialogManager.checkEmptyFields(getString(R.string.err_both_password), txtConfirmPassword);
                    return;
                }
                callAPIRequest();
            } catch (Exception e) {
                Utils.getErrors(e);
            }
        });

    }

    /**
     * Call API request
     */
    private void callAPIRequest() {
        showWaitDialog();
        try {
            ApiInterface apiInterface = RestAdapter.createAPI(mActivity);
            callbackCall = apiInterface.changePassword(Utils.getAPIKey(mActivity), strUsername, strEmail, strOldPassword, strNewPassword);
            callbackCall.enqueue(new Callback<>() {
                @Override
                public void onResponse(@NonNull Call<CallbackUser> call, @NonNull Response<CallbackUser> response) {
                    hideWaitDialog();
                    final CallbackUser resp = response.body();
                    if (resp != null && resp.status.equals(Constant.SUCCESS)) {
                        SessionManager.get().setUserModel(resp.data);
                        onRequestMessage(!Utils.isEmpty(resp.message) ? resp.message : getString(R.string.err_failed_to_load), TRUE);
                    } else {
                        assert resp != null;
                        onRequestMessage(!Utils.isEmpty(resp.message) ? resp.message : getString(R.string.err_failed_to_load), FALSE);
                    }
                }

                @Override
                public void onFailure(@NonNull Call<CallbackUser> call, @NonNull Throwable t) {
                    hideWaitDialog();
                    if (!call.isCanceled()) onRequestMessage(getString(R.string.lblFailed), FALSE);
                }
            });
        } catch (Exception e) {
            hideWaitDialog();
            Utils.getErrors(e);
        }

    }

    /**
     * Show response message which return from API call
     */
    private void onRequestMessage(String strMessage, boolean isActivityFinish) {
        try {
            if (Utils.isOnline(mActivity)) {
                DialogManager.showOKDialog(mActivity, getString(R.string.lblChangePassword), strMessage, isActivityFinish);
            } else {
                DialogManager.showNoInternetDialog();
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Cancel call if its running
     */
    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            if (callbackCall != null && callbackCall.isExecuted()) {
                callbackCall.cancel();
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }
}
